//
//  ViewController.m
//  CQAdDemo
//
//  Created by bell on 2021/9/27.
//

#import "ViewController.h"
#import <CQAdSDK/CQAdSDK.h>
#import "CQAdFeedAdDemoViewController.h"
#import "CQAdNativeAdDemoViewController.h"

@interface ViewController ()<CQAdSplashAdDelegate, CQAdInterstitialAdDelegate,CQAdRewardVideoAdDelegate>

@property (nonatomic, strong) CQAdSplashAd* splashAd;

@property (nonatomic, strong) CQAdInterstitialAd* interstitialAd;

@property (nonatomic, strong) CQAdRewardVideoAd* rewardVideoAd;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupViews];
}

- (void)setupViews
{
    self.view.backgroundColor = UIColor.whiteColor;
    
    CGRect viewFrame = self.view.frame;
    {
        UIButton* button = [UIButton buttonWithType:(UIButtonTypeSystem)];
        button.frame = CGRectMake((viewFrame.size.width - 160)/2, 120, 160, 40);
        button.layer.borderColor = UIColor.grayColor.CGColor;
        button.layer.borderWidth = 1;
        [self.view addSubview:button];
        [button setTitle:@"开屏广告测试" forState:(UIControlStateNormal)];
        [button addTarget:self action:@selector(loadSplashAd) forControlEvents:(UIControlEventTouchUpInside)];
    }
    
    {
        UIButton* button = [UIButton buttonWithType:(UIButtonTypeSystem)];
        button.frame = CGRectMake((viewFrame.size.width - 160)/2, 180, 160, 40);
        button.layer.borderColor = UIColor.grayColor.CGColor;
        button.layer.borderWidth = 1;
        [self.view addSubview:button];
        [button setTitle:@"插屏广告测试" forState:(UIControlStateNormal)];
        [button addTarget:self action:@selector(loadInterstitialAd) forControlEvents:(UIControlEventTouchUpInside)];
    }
    
    {
        UIButton* button = [UIButton buttonWithType:(UIButtonTypeSystem)];
        button.frame = CGRectMake((viewFrame.size.width - 160)/2, 240, 160, 40);
        button.layer.borderColor = UIColor.grayColor.CGColor;
        button.layer.borderWidth = 1;
        [self.view addSubview:button];
        [button setTitle:@"模板信息流广告测试" forState:(UIControlStateNormal)];
        [button addTarget:self action:@selector(testExpressAd) forControlEvents:(UIControlEventTouchUpInside)];
    }
    
    {
        UIButton* button = [UIButton buttonWithType:(UIButtonTypeSystem)];
        button.frame = CGRectMake((viewFrame.size.width - 160)/2, 300, 160, 40);
        button.layer.borderColor = UIColor.grayColor.CGColor;
        button.layer.borderWidth = 1;
        [self.view addSubview:button];
        [button setTitle:@"自渲染信息流广告测试" forState:(UIControlStateNormal)];
        [button addTarget:self action:@selector(testNativeAd) forControlEvents:(UIControlEventTouchUpInside)];
    }
}
-(void)openGame
{
    [CQAdGameManager openGame:@"xxx" extra:@{@"xx":@"xx"} completion:^(BOOL success, NSError * _Nullable error) {
        
    }];
}

-(void)testNativeAd
{
    CQAdNativeAdDemoViewController* vc = [[CQAdNativeAdDemoViewController alloc] initWithNibName:nil bundle:nil];
    [self.navigationController pushViewController:vc animated:YES];
}


-(void)setLimit:(UIButton *)sender
{
    sender.selected = !sender.selected;
    
    [[NSUserDefaults standardUserDefaults] setObject:sender.selected?@"1":@"0" forKey:@"isLimit"];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

//===================================================================
- (void)testExpressAd
{
    CQAdFeedAdDemoViewController* vc = [[CQAdFeedAdDemoViewController alloc] initWithNibName:nil bundle:nil];
    [self.navigationController pushViewController:vc animated:YES];
}

//===================================================================

- (void)loadInterstitialAd
{
    self.interstitialAd = [[CQAdInterstitialAd alloc] initWithPlacementId:@"3000015475" viewController:self];

    self.interstitialAd.delegate = self;
    [self.interstitialAd loadAd];
}
#pragma mark interstitial ad delegate

- (void)cqAdInterstitialAdLoadSuccess:(CQAdInterstitialAd *)interstitialAd
{
    NSLog(@"CQAdInterstitialAd:cqAdInterstitialAdLoadSuccess");
    [interstitialAd showAd];
    

}

- (void)cqAdInterstitialAdLoadFailed:(CQAdInterstitialAd *)interstitialAd error:(NSError *)error
{
    NSLog(@"CQAdInterstitialAd:cqAdInterstitialAdLoadFailed error = %@", error);
    

}

- (void)cqAdInterstitialAdVisible:(CQAdInterstitialAd *)interstitialAd
{
    NSLog(@"CQAdInterstitialAd:cqAdInterstitialAdVisible");
    

}

- (void)cqAdInterstitialAdDidClick:(CQAdInterstitialAd *)interstitialAd
{
    NSLog(@"CQAdInterstitialAd:cqAdInterstitialAdDidClick");
    

}

- (void)cqAdInterstitialAdDidClose:(CQAdInterstitialAd *)interstitialAd
{
    NSLog(@"CQAdInterstitialAd:cqAdInterstitialAdDidClose");
    

}


//===================================================================
//Splash Ad Test
- (void)loadSplashAd
{
    UIWindow* window = [[UIApplication.sharedApplication delegate] window];
    
    CQAdSplashAd* splashAd = [[CQAdSplashAd alloc] initWithPlacementId:@"1000015462" window:window bottomView:nil timeout:6];
    splashAd.delegate = self;
    [splashAd loadAd];
    self.splashAd = splashAd;
}

#pragma mark splash ad delegate

- (void)cqAdSplashAdLoadSuccess:(CQAdSplashAd*)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdLoadSuccess");
    [splashAd showAd];
    
    
}

- (void)cqAdSplashAdLoadFailed:(CQAdSplashAd*)splashAd error:(NSError*)error
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdLoadFailed error=%@", error);
    

}

- (void)cqAdSplashAdDidClick:(CQAdSplashAd*)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdDidClick");
    

}

- (void)cqAdSplashAdDidClose:(CQAdSplashAd *)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdDidClose");
    

}

- (void)cqAdSplashAdVisible:(CQAdSplashAd *)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdVisible");
    

}
@end
